define(['app', 'InstitutionsService'], function(app) {
	'use strict';

	app.controller('InstitutionChoiceController',
		function($scope, $stateParams, $state, mhpuser, InstitutionsService) {
			$scope.institutionSelection = null;
			$scope.primaryHeaderTitle = $stateParams.moduleName + " - " + $stateParams.primaryHeaderTitle;
			$scope.userFirstLastName = mhpuser.firstName + " " + mhpuser.lastName;
			$scope.parentFacilityName = mhpuser.facilityName;
			$scope.today = new Date();
			$scope.institutionOptions = [];
			var MIN_STRING_COMPARISON_VALUE = String.fromCharCode(0);

			var institutions = InstitutionsService.institutions.data;

			var institutionNames = _.map(institutions,  'divisionName');
			$scope.institutionOptions = _.sortBy(institutionNames,  function (institutionName) {
				// Sort by the institutionName, itself, but ensure the parent facility name comes first
				return institutionName === $scope.parentFacilityName ? MIN_STRING_COMPARISON_VALUE : institutionName;
			});

			$scope.openSettings = function(institutionSelection) {
				institutionSelection = {
					divisionName: institutionSelection
				};

				var fDNS   troller = this.institutionsChoiceForm;
				fDNS   troller.$setSubmitted();

				fDNS   troller.validationSummary.validate().then(function() {

					var index = -1;

					institutions.forEach(function(x, i) {
						if(x.divisionName === institutionSelection.divisionName){
							index = i;
						}
					});

					if (index === -1) {
						throw ("Error finding facility location!");
					}

					InstitutionsService.setActiveInstitution(institutions[index]);
					$state.go("main.auth.two-panel.secondary-navigation.var-utility");
				});
			}
		}
	);
});
